<?php
require("MySQLDAO.php");
$config = parse_ini_file('../config/config.ini');

$returnValue = array();

if(empty($_GET["username"]) || empty($_GET["password"]))
{
    $returnValue["status"]="400";
    $returnValue["message"]="Missing required information";
    echo json_encode($returnValue);
    return;
}

$username = $_GET["username"];
$password = $_GET["password"];

$dbhost = trim($config["dbhost"]);
$dbuser = trim($config["dbuser"]);
$dbpassword = trim($config["dbpassword"]);
$dbname = trim($config["dbname"]);

$dao = new MySQLDAO($dbhost, $dbuser, $dbpassword, $dbname);

$dao->openConnection();
$userDetails =$dao->getUserDetails($username);

if(empty($userDetails))
{
    $returnValue["status"]="403";
    $returnValue["message"]="User not found";
    echo json_encode($returnValue);
    return;   
}


if( !$userDetails["is_supervisor"]   )
{
    $returnValue["status"]="403";
    $returnValue["message"]="User is Not supervisor !!!";
    echo json_encode($returnValue);
    return;   
}

$userSecuredPassword = $userDetails["password"];  // encrepted password 

if (password_verify($password, $userSecuredPassword)) 
{

    $returnValue["status"]="200";
    $returnValue["id"] = $userDetails["id"];
    $returnValue["name"] = $userDetails["name"];
	$returnValue["email"] = $userDetails["email"];
} else {
    $returnValue["status"]="403";
    $returnValue["message"]="User not found";
    echo json_encode($returnValue);
    return;
}


$dao->closeConnection();

echo json_encode($returnValue);

?>
