<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Activity;

class Main extends Model
{
    public $timestamps = true;
    protected $table = 'mains';
    protected $fillable = [
       'quantity','created_at','updated_at','supplier_id','waste_id','packingmethod_id',
       'physicalcondition_id','driver_id','vehicle_id','customer_id','user_id','approve','price_id'
    ];

    public function supplier()
    {
        return $this->belongsTo('App\Supplier', 'supplier_id');
    }

    public function waste()
    {
        return $this->belongsTo('App\Waste', 'waste_id');
    }

    public function packingmethod()
    {
        return $this->belongsTo('App\Packingmethod','packingmethod_id');
    }
    
    public function physicalcondition()
    {
        return $this->belongsTo('App\Physicalcondition','physicalcondition_id');
    }

    public function driver()
    {
        return $this->belongsTo('App\Driver','driver_id');
    }

    public function vehicle()
    {
        return $this->belongsTo('App\Vehicle','vehicle_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User','user_id');
    }

    public function customer()
    {
        return $this->belongsTo('App\Customer','customer_id');
    }

    public function price()
    {
        return $this->belongsTo('App\Price','price_id');
    }


}

