<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\Price;
use App\Waste;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class PriceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function price_edit_get()
    {
        $wastes =  DB::table("waste")->select('id', 'name')->get(); // use it as for each / provided the name and id 
        $price = Price::orderBy('created_at', 'desc')->first(); /// one object {"id":1,"created_at":"2022-07-19 02:08:19","updated_at":"2022-07-19 02:08:19","p5":10,"p6":11,"p7":12,"p8":13}
        return view('price.edit' , ['wastes' => $wastes , 'price' =>$price ]);
    }


    public function price_edit_post(Request $request)
    {
               
       try {

        $json = json_encode($request->except('_token'), JSON_NUMERIC_CHECK );
        $array = json_decode($json, TRUE);

        $last_inserted_row = Price::orderBy('created_at', 'desc')->select( 'created_at', 'id')->first(); 
        
        $last_date =  Str::substr($last_inserted_row->created_at, 0, 10);
         
        $last_id = $last_inserted_row->id;
        $current_date  = Carbon::now()->toDateString();

        
        if ( $last_date < $current_date){
            // insert if not exist 
            $price = Price::create ( $array);
            session()->flash('message', 'New Market Price Added Successfully ');
            
    
        } else  if ( $last_date == $current_date){ 
            // edit if exist
            Price::where('id',$last_id)->update($array);
            session()->flash('message', 'New Market Price Edited Successfully ');
            
        }
        session()->flash('type', 'success');
        return redirect ( "/price/edit_get" );

      } catch (\Exception $e) {
      
        session()->flash('message', $e->getMessage());
        session()->flash('type', 'danger');
        return redirect ( "/price/edit_get" );

      }
    }

}
