<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Permit;
use  App\Vehicle;
use  App\Driver;
use Carbon\Carbon;

class DriverController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Driver
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function driver_show()
{
    $drivers = Driver::get();
    return view('driver.show' , ['drivers' => $drivers]);
}
public function driver_create_get()
{
    return view('driver.create');
}
public function driver_create(Request $request) {
    
    $driver = Driver::create ( [ 		
            'name' => $request ['name'],
            'national_id' => $request ['national_id'],
            'driver_license' => $request ['driver_license']
    ] );    
    session()->flash('message', 'New Driver Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/driver/index" );
}

public function driver_edit_get($driver_id){
    $driver = DB::table('drivers')->where('id', '=',$driver_id)->first();
    return view('driver.edit',[
                            'driver' => $driver
                            ]);
}
public function driver_edit_post(Request $request){
    $driver_id = $request ['driver_id'];
    $name = $request ['name'];
    $national_id = $request ['national_id']; 
    $driver_license = $request ['driver_license'];
    DB::table('drivers')
        ->where('id', $driver_id)
        ->update(['name' => $name,'national_id' => $national_id,
            'driver_license' => $driver_license,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Driver Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/driver/edit/$driver_id" );
}
public function driver_delete($driver_id){
        
        $driver = Driver::find($driver_id);
        $driver->delete();
        return redirect ( "/driver/index");
    }


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Vehicles 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function vehicle_show()
{
    $vehicles = Vehicle::get();
    return view('vehicle.show' , ['vehicles' => $vehicles]);
}
public function vehicle_create_get()
{
    return view('vehicle.create');
}
public function vehicle_create(Request $request) {
    
    $vehicle = Vehicle::create ( [ 		
            'vehicle_num' => $request ['vehicle_num'],
            'driving_license' => $request ['driving_license']
    ] );    
    session()->flash('message', 'New Vehicle Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/vehicle/index" );
}

public function vehicle_edit_get($vehicle_id){
    $vehicle = DB::table('vehicles')->where('id', '=',$vehicle_id)->first();
    return view('vehicle.edit',[
                            'vehicle' => $vehicle
                            ]);
}
public function vehicle_edit_post(Request $request){
    $vehicle_id = $request ['vehicle_id'];
     $vehicle_num = $request ['vehicle_num']; 
    $driving_license = $request ['driving_license'];
    DB::table('vehicles')
        ->where('id', $vehicle_id)
        ->update(['vehicle_num' => $vehicle_num,
                  'driving_license' => $driving_license,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Vehicle Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/vehicle/edit/$vehicle_id" );
}
public function vehicle_delete($vehicle_id){
        
        $vehicle = Vehicle::find($vehicle_id);
        $vehicle->delete();
        return redirect ( "/vehicle/index");
    }


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Permit 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function permit_show()
{
    $permits = Permit::with('vehicle')->get();
  
    return view('permit.show' , ['permits' => $permits ]);
}
public function permit_create_get()
{
    $vehicles = Vehicle::get();
    return view('permit.create',['vehicles' => $vehicles]);
}
public function permit_create(Request $request) {
    
    $permit = Permit::create ( [ 		
            'start' => $request ['start'],
            'end' => $request ['end'],
            'comment' => $request ['comment'],
            'sader_mn' => $request ['sader_mn'],
            'name' => $request ['name'],
            'vehicle_id' => $request ['vehicle_id']
    ] );    
    session()->flash('message', 'New Permit Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/permit/index" );
}

public function permit_edit_get($permit_id){
    $permit = DB::table('permit')->where('id', '=',$permit_id)->first();
    $vehicles = Vehicle::get();
    return view('permit.edit',[
                            'permit' => $permit,
                            'vehicles' => $vehicles
                            ]);
}
public function permit_edit_post(Request $request){
     $permit_id = $request ['permit_id'];
     $name = $request ['name']; 
     $start = $request ['start']; 
     $end = $request ['end']; 
     $comment = $request ['comment']; 
     $sader_mn = $request ['sader_mn']; 
    $vehicle_id = $request ['vehicle_id'];
    DB::table('permit')
        ->where('id', $permit_id)
        ->update([
                  'start' => $start,
                  'end' => $end,
                  'comment' => $comment,
                  'sader_mn' => $sader_mn,
                  'name' => $name,
                  'vehicle_id' => $vehicle_id,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Permit Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/permit/edit/$permit_id" );
}
public function permit_delete($permit_id){
        
        $permit = Permit::find($permit_id);
        $permit->delete();
        return redirect ( "/permit/index");
    }

  
   
    

}
