<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\RecycleMethod;
use  App\Waste;
use  App\Store;
use Carbon\Carbon;
use  App\Packingmethod;
use  App\Physicalcondition;
use Illuminate\Support\Facades\Schema;
use Session;
use Auth; 
use App\Actions;

class WasteController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 // class   
 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function class_show()
    {
        $classes = Class_::get();
        return view('waste.class.show' , ['classes' => $classes]);
    }
    public function class_create_get()
    {
        return view('waste.class.create');
    }
    public function class_create(Request $request) {
		
		$class = Class_::create ( [ 		
				'name' => $request ['name'],
		] );    
        session()->flash('message', 'New Class Added Successfully');
        session()->flash('type', 'success');
		return redirect ( "/class/index" );
	}

    public function class_edit_get($class_id){
        $class = DB::table('class')->where('id', '=',$class_id)->first();
        return view('waste.class.edit',[
                                'class' => $class
                                ]);
    }
    public function class_edit_post(Request $request){
        $class_id = $request ['class_id'];
        $class_name = $request ['name'];
        DB::table('class')
            ->where('id', $class_id)
            ->update(['name' => $class_name, 'updated_at' => Carbon::now()]);
		        
        session()->flash('message', 'Class Updated successfully');
        session()->flash('type', 'success');

		return redirect ( "/class/edit/$class_id" );
    }
    public function class_delete($class_id){
            
            $class = Class_::find($class_id);
            $class->delete();
            return redirect ( "/class/index");
        }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Classification
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  public function classification_show()
  {
      $classifications = Classification::get();
      return view('waste.classification.show' , ['classifications' => $classifications]);
  }
  public function classification_create_get()
  {
      return view('waste.classification.create');
  }
  public function classification_create(Request $request) {
      
      $classification = Classification::create ( [ 		
              'name' => $request ['name'],
      ] );    
      session()->flash('message', 'New Classification Added Successfully');
      session()->flash('type', 'success');
      return redirect ( "/classification/index" );
  }

  public function classification_edit_get($classification_id){
      $classification = DB::table('classifications')->where('id', '=',$classification_id)->first();
      return view('waste.classification.edit',[
                              'classification' => $classification
                              ]);
  }
  public function classification_edit_post(Request $request){
      $classification_id = $request ['classification_id'];
      $classification_name = $request ['name'];
      DB::table('classifications')
          ->where('id', $classification_id)
          ->update(['name' => $classification_name, 'updated_at' => Carbon::now()]);
              
      session()->flash('message', 'Classification Updated successfully');
      session()->flash('type', 'success');

      return redirect ( "/classification/edit/$classification_id" );
  }
  public function classification_delete($classification_id){
          
          $classification = Classification::find($classification_id);
          $classification->delete();
          return redirect ( "/classification/index");
      }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Group
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function group_show()
{
    $groups = Group::get();
    return view('waste.group.show' , ['groups' => $groups]);
}
public function group_create_get()
{
    return view('waste.group.create');
}
public function group_create(Request $request) {
    
    $group = Group::create ( [ 		
            'name' => $request ['name'],
    ] );    
    session()->flash('message', 'New Group Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/group/index" );
}

public function group_edit_get($group_id){
    $group = DB::table('groups')->where('id', '=',$group_id)->first();
    return view('waste.group.edit',[
                            'group' => $group
                            ]);
}
public function group_edit_post(Request $request){
    $group_id = $request ['group_id'];
    $group_name = $request ['name'];
    DB::table('groups')
        ->where('id', $group_id)
        ->update(['name' => $group_name, 'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Group Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/group/edit/$group_id" );
}
public function group_delete($group_id){
        
        $group = Group::find($group_id);
        $group->delete();
        return redirect ( "/group/index");
    }
  

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Transporter
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function transporter_show()
{
    $transporters = Transporter::get();
    return view('waste.transporter.show' , ['transporters' => $transporters]);
}
public function transporter_create_get()
{
    return view('waste.transporter.create');
}
public function transporter_create(Request $request) {
    
    $transporter = Transporter::create ( [ 		
            'waste_transporter' => $request ['waste_transporter'],
            'phone' => $request ['phone'],
            'address' => $request ['address'],
            'license_nom' => $request ['license_nom'],
            'indesterial_reg_nom' => $request ['indesterial_reg_nom'],
            'env_approve_nom' => $request ['env_approve_nom'],
            'activity' => $request ['activity'],
            'commertial_record' => $request ['commertial_record'],
            'tax_card' => $request ['tax_card'],
    ] );    
    session()->flash('message', 'New Transporter Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/transporter/index" );
}

public function transporter_edit_get($transporter_id){
    $transporter = DB::table('transporters')->where('id', '=',$transporter_id)->first();
    return view('waste.transporter.edit',[
                            'transporter' => $transporter
                            ]);
}
public function transporter_edit_post(Request $request){
    $transporter_id = $request ['transporter_id'];
    $waste_transporter = $request ['waste_transporter'];
    $phone = $request ['phone'];
    $address = $request ['address'];
    $license_nom = $request ['license_nom'];
    $indesterial_reg_nom = $request ['indesterial_reg_nom'];
    $env_approve_nom = $request ['env_approve_nom'];
    $activity = $request ['activity'];
    $commertial_record = $request ['commertial_record'];
    $tax_card = $request ['tax_card'];

    DB::table('transporters')
        ->where('id', $transporter_id)
        ->update([
            'waste_transporter' => $waste_transporter,
            'phone' => $phone,
            'address' => $address,
            'license_nom' => $license_nom,
            'indesterial_reg_nom' => $indesterial_reg_nom,
            'env_approve_nom' => $env_approve_nom,
            'activity' => $activity,
            'commertial_record' => $commertial_record,
            'tax_card' => $tax_card,
            'updated_at' => Carbon::now()
        ]);
            
    session()->flash('message', 'Transporter Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/transporter/edit/$transporter_id" );
}
public function transporter_delete($transporter_id){
        
        $transporter = Transporter::find($transporter_id);
        $transporter->delete();
        return redirect ( "/transporter/index");
    }

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Recycle_method 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function recycle_method_show()
{
    $recycle_methods = RecycleMethod::get();
    return view('waste.recycle_method.show' , ['recycle_methods' => $recycle_methods]);
}
public function recycle_method_create_get()
{
    return view('waste.recycle_method.create');
}
public function recycle_method_create(Request $request) {
    
    $recycle_method = RecycleMethod::create ( [ 		
            'name' => $request ['name'],
    ] );    
    session()->flash('message', 'New Recycle Method Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/recycle_method/index" );
}

public function recycle_method_edit_get($recycle_method_id){
    $recycle_method = DB::table('reuse_methods')->where('id', '=',$recycle_method_id)->first();
    return view('waste.recycle_method.edit',[
                            'recycle_method' => $recycle_method
                            ]);
}
public function recycle_method_edit_post(Request $request){
    $recycle_method_id = $request ['recycle_method_id'];
    $recycle_method_name = $request ['name'];
    DB::table('reuse_methods')
        ->where('id', $recycle_method_id)
        ->update(['name' => $recycle_method_name, 'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Recycle Method Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/recycle_method/edit/$recycle_method_id" );
}
public function recycle_method_delete($recycle_method_id){
        
        $recycle_method = RecycleMethod::find($recycle_method_id);
        $recycle_method->delete();
        return redirect ( "/recycle_method/index");
    }
    
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Waste 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function waste_show()
{
    $wastes = Waste::with('class_','classification','group','res_method')->get();
    //echo $wastes[0]->class_;
      ///////////////// action /////////////////
        
       $action = "Show Wastes " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Show All Wastes "
            ] );
        /////////////////////////////////
        
    return view('waste.show' , ['wastes' => $wastes]);
}
public function waste_create_get()
{
    $classes = Class_::get();
    $classifications = Classification::get();
    $groups = Group::get();
    $recycle_methods = RecycleMethod::get();
    $stores = Store::get();
    return view('waste.create' , [
        'classes' => $classes,
        'classifications' => $classifications,
        'groups' => $groups,
        'recycle_methods' => $recycle_methods,
        'stores'=>$stores,
    ]);
}
public function waste_create(Request $request) {
    
    $waste = Waste::create ( [ 		
            'name' => $request ['name'],
            'unit' => $request ['unit'],
            'price' => $request ['price'],
            'tax' => $request ['tax'],
            'class_id'=>$request ['class_id'],
            'classifications_id'=>$request ['classifications_id'],
            'groups_id'=>$request ['groups_id'],
            'reuse_methods_id'=>$request ['reuse_methods_id'],
            'store_id'=>$request ['store_id'],
    ] );
     

 ///////////////// action /////////////////
        
       $action = "Create new Waste " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Create new Waste  $waste->name"
            ] );
        /////////////////////////////////
        
    session()->flash('message', 'New Waste Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/waste/index" );
}

public function waste_edit_get($waste_id){
    $classes = Class_::get();
    $classifications = Classification::get();
    $groups = Group::get();
    $recycle_methods = RecycleMethod::get();
    $waste = DB::table('waste')->where('id', '=',$waste_id)->first();
    $stores = Store::get();
    return view('waste.edit',[
            'waste' => $waste,
            'classes' => $classes,
            'classifications' => $classifications,
            'groups' => $groups,
            'recycle_methods' => $recycle_methods,
            'stores'=>$stores
    ]);
}
public function waste_edit_post(Request $request){
    $waste_id = $request ['waste_id'];
    $waste_name = $request ['name'];
    $waste_unit = $request ['unit'];
    $class_id = $request ['class_id'];
    $classifications_id = $request ['classifications_id'];
    $groups_id = $request ['groups_id'];
    $reuse_methods_id = $request ['reuse_methods_id'];
    $price = $request ['price'];
    $tax = $request ['tax'];
    $store_id = $request ['store_id'];
    /////////////////actions//////////////////
    $old_waste = Waste::where('id',$waste_id)->first();
    ///////////////////////////////////////////////////
    
    DB::table('waste')
        ->where('id', $waste_id)
        ->update([
        'name' => $waste_name,
        'unit' => $waste_unit,
        'price' => $price,
        'tax' => $tax,
        'class_id' => $class_id,
        'classifications_id' => $classifications_id,
        'groups_id' => $groups_id,
        'reuse_methods_id' => $reuse_methods_id,
        'store_id'=>$store_id,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Waste Updated successfully');
    session()->flash('type', 'success');


 ///////////////// action /////////////////
       $action = "Edit Waste Not Carta   " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Edit Waste  waste_id: $waste_id , waste_name:$waste_name , unit: $waste_unit , class:$class_id , classfication: $classifications_id , group: $groups_id , price: $price , tax:$tax , reuse_methods_id:$reuse_methods_id   ==> old ==>  $old_waste "
            ] );
        /////////////////////////////////
        
        
    return redirect ( "/waste/edit/$waste_id" );
}

    
    public function waste_delete($waste_id){
        
        $waste = Waste::find($waste_id);
        $waste->delete();

 ///////////////// action /////////////////
       $action = "Delete Waste Not Carta   " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Delete Waste  num  : $waste_id "
            ] );
        /////////////////////////////////
        

        return redirect ( "/waste/index");
}


   
  
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Packing Method
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function packingmethod_show()
{
    $packingmethods = Packingmethod::get();
    return view('packingmethod.show' , ['packingmethods' => $packingmethods]);
}
public function packingmethod_create_get()
{
    return view('packingmethod.create');
}
public function packingmethod_create(Request $request) {
    
    $packingmethod = Packingmethod::create ( [ 		
            'name' => $request ['name'],
    ] );    
    session()->flash('message', 'New Packing Method Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/packingmethod/index" );
}

public function packingmethod_edit_get($packingmethod_id){
    $packingmethod = DB::table('packingmethods')->where('id', '=',$packingmethod_id)->first();
    return view('packingmethod.edit',[
                            'packingmethod' => $packingmethod
                            ]);
}
public function packingmethod_edit_post(Request $request){
    $packingmethod_id = $request ['packingmethod_id'];
    $packingmethod_name = $request ['name'];
    DB::table('packingmethods')
        ->where('id', $packingmethod_id)
        ->update(['name' => $packingmethod_name, 'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Packing Method Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/packingmethod/edit/$packingmethod_id" );
}
public function packingmethod_delete($packingmethod_id){
        
        $packingmethod = Packingmethod::find($packingmethod_id);
        $packingmethod->delete();
        return redirect ( "/packingmethod/index");
    }



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Physical Conditions
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function physicalcondition_show()
{
    $physicalconditions = Physicalcondition::get();
    return view('physicalcondition.show' , ['physicalconditions' => $physicalconditions]);
}
public function physicalcondition_create_get()
{
    return view('physicalcondition.create');
}
public function physicalcondition_create(Request $request) {
    
    $physicalcondition = Physicalcondition::create ( [ 		
            'name' => $request ['name'],
    ] );    
    session()->flash('message', 'New Physical Condition Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/physicalcondition/index" );
}

public function physicalcondition_edit_get($physicalcondition_id){
    $physicalcondition = DB::table('physicalconditions')->where('id', '=',$physicalcondition_id)->first();
    return view('physicalcondition.edit',[
                            'physicalcondition' => $physicalcondition
                            ]);
}
public function physicalcondition_edit_post(Request $request){
    $physicalcondition_id = $request ['physicalcondition_id'];
    $physicalcondition_name = $request ['name'];
    DB::table('physicalconditions')
        ->where('id', $physicalcondition_id)
        ->update(['name' => $physicalcondition_name, 'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Physical Condition Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/physicalcondition/edit/$physicalcondition_id" );
}
public function physicalcondition_delete($physicalcondition_id){
        
        $physicalcondition = Physicalcondition::find($physicalcondition_id);
        $physicalcondition->delete();
        return redirect ( "/physicalcondition/index");
    }


}
