<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth;
use App\Actions;
class InvoiceReportController  extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        return view('invoicereport.create');
        
    }

    // ajax
    public function get_suppliers($from , $to){
        
         $mains = Main::with("supplier")
                                    ->whereDate('created_at','>=',$from)
                                    ->whereDate('created_at','<=',$to)
                                    ->groupBy('supplier_id')
                                    //->where('customer_id' , '!=' , NULL)
                                    ->get();
   // sleep(3);
        return \Response::json(['suppliers_' => $mains, ]);

    }

    // ajax
    public function get_classes( $supplier_id , $from , $to){


        $mains = Main::with("waste")
        ->whereDate('created_at','>=',$from)
        ->whereDate('created_at','<=',$to)
        //->where('customer_id' , '!=' , NULL) 
        ->where('supplier_id' , $supplier_id)                            
        ->groupBy('waste_id')
        ->get();

        $class_ids = [];
        foreach ( $mains as $main ) {
        $class_ids[] = $main->waste->class_id;
        }

        $classes_ = Class_::whereIn('id', $class_ids)->groupBy('name')->get(); // get all classes where belongs to the wastes of suppliers but no dublicates 
        //sleep(3);
        return \Response::json(['classes_' => $classes_, ]);

    }



    public function invoice_report_create_post(Request $request) {
    
        
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $supplier_id = $request ['invoice_supplier_id']; 
        $selected_classes = $request ['invoice_classes']; 
         

       
        $mains = Main::with("waste", "supplier")->where('supplier_id', $supplier_id)
        //->where('customer_id' , '!=' , NULL)
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->orderBy('created_at', 'asc')
        ->get();

          

        
        $sum_kg=0;  // kg
        $sum_num=0;  // عدد
        $total_price=0;  // sum of total price whatever kg or num
        $final_mains = [];
        foreach ($mains as $main) {
            if (in_array( $main->waste->class_id , $selected_classes)){
                $final_mains [] = $main ;
                

                if( $main->waste->unit == 'كجم' ){
                    $sum_kg = $sum_kg + $main->quantity;
                }else{
                    $sum_num = $sum_num + $main->quantity;
                }
                if ( $main->price) {
                    $price_ = $main->price * $main->quantity ; // multibly the quantity in price per unit 
                    $total_price = $total_price + $price_  ;
                }
            } 

        }
         

           ///////////////// action /////////////////

        $subject = "Egwaste Invoice  From : ".$dateFrom ."  to : ".$dateTo."For Supplier ".$supplier_id;
        $action = "Invoice"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
         //sleep(3);
         
        return view('invoicereport.show', [
            'mains'=>$final_mains,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo,
            'sum_kg'=>$sum_kg,
            'sum_num'=>$sum_num,
            'total_price'=>$total_price
        ]);
        
    }

    




}
