<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Customer;
use App\City;
use Auth;
use Carbon\Carbon;
class CustomerController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

/////////////////////////////////////////////////////////////////////////////////////////////////////
///////// Customers
//////////////////////////////////////////////////////////////////////////////////////////////////////
    public function customer_show()
{
    $customers = Customer::with('city')->get();
    return view('customer.show' , ['customers' => $customers]);
}
public function customer_create_get()
{
    $citys = City::get();
  return view('customer.create', ['citys' => $citys]);
}



public function customer_create(Request $request) {
    
     
    $customer = Customer::create ( [ 
            'name' => $request ['name'],
            'address' => $request ['address'],
            'phone' => $request ['phone'],
            'fax' => $request ['fax'],
            'email' => $request ['email'],
            'responsable_name' => $request ['responsable_name'],
            'responsable_position' => $request ['responsable_position'],
            'responsable_phone' => $request ['responsable_phone'],
            'responsable_email' => $request ['responsable_email'],
            'commertial_registration_no' => $request ['commertial_registration_no'],
            'tax_card_no' => $request ['tax_card_no'],
            'operating_licence_no' => $request ['operating_licence_no'],
            'activity' => $request ['activity'],
            'industrial_registration_no' => $request ['industrial_registration_no'],
            'industrial_city_id' => $request ['industrial_city_id'],
            'env_approve_nom' => $request['env_approve_nom']
    ] );
     
    session()->flash('message', 'New Customer Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/customer/index" );
}

public function customer_edit_get($customer_id){
     
    $customer = DB::table('customers')->where('id', '=',$customer_id)->first();
    $citys = City::get();

    return view('customer.edit',[
            'customer' => $customer, 'citys' => $citys
    ]);
}
public function customer_edit_post(Request $request){
    $customer_id = $request ['customer_id'];
    $name = $request ['name'];
    $address = $request ['address'];
    $phone = $request ['phone'];
    $fax = $request ['fax'];
    $email = $request ['email'];
    $responsable_name = $request ['responsable_name'];
    $responsable_position = $request ['responsable_position'];
    $responsable_phone = $request ['responsable_phone'];
    $responsable_email = $request ['responsable_email'];
    $commertial_registration_no = $request ['commertial_registration_no'];
    $tax_card_no = $request ['tax_card_no'];
    $operating_licence_no = $request ['operating_licence_no'];
    $activity = $request ['activity'];
    $industrial_registration_no = $request ['industrial_registration_no'];
    $industrial_city_id = $request ['industrial_city_id'];
    $env_approve_nom = $request['env_approve_nom'];

    DB::table('customers')
        ->where('id', $customer_id)
        ->update([
            'name' => $name,
            'address' => $address,
            'phone' => $phone,
            'fax' => $fax,
            'email' => $email,
            'responsable_name' => $responsable_name,
            'responsable_position' => $responsable_position,
            'responsable_phone' => $responsable_phone,
            'responsable_email' => $responsable_email,
            'commertial_registration_no' => $commertial_registration_no,
            'tax_card_no' => $tax_card_no,
            'operating_licence_no' => $operating_licence_no,
            'industrial_registration_no' => $industrial_registration_no,
            'activity' => $activity,
            'industrial_city_id' => $industrial_city_id,
            'env_approve_nom' => $env_approve_nom,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'Customer Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/customer/edit/$customer_id" );
}
public function customer_delete($customer_id){
        
        $customer = Customer::find($customer_id);
        $customer->delete();
        return redirect ( "/customer/index");
    }

     
	 
	
   


}
