<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Branch;
use App\Store;
use App\Store_Branch;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class BranchController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function branch_show()
    {
        $branchs = Branch::get();
        return view('branch.show' , ['branchs' => $branchs]);
    }
    public function branch_create_get()
    {
        return view('branch.create');
    }
    public function branch_create(Request $request) {
        
        $branch = Branch::create ( [ 		
                'name' => $request ['name'],
                'address' => $request ['address']
        ] );    
        session()->flash('message', 'New branch Added Successfully');
        session()->flash('type', 'success');
        return redirect ( "/branch/index" );
    }
    
    public function branch_edit_get($branch_id){
        $branch = DB::table('branches')->where('id', '=',$branch_id)->first();
        return view('branch.edit',[
                                'branch' => $branch
                                ]);
    }
    public function branch_edit_post(Request $request){
        $branch_id = $request ['branch_id'];
         $name = $request ['name']; 
        $address = $request ['address'];
        DB::table('branches')
            ->where('id', $branch_id)
            ->update(['name' => $name,
                      'address' => $address,
             'updated_at' => Carbon::now()]);
                
        session()->flash('message', 'branch Updated successfully');
        session()->flash('type', 'success');
    
        return redirect ( "/branch/edit/$branch_id" );
    }
    
     public function branch_delete($branch_id){
        
        $branch = Branch::find($branch_id);
        $branch->delete();
        return redirect ( "/branch/index");
    }
     
//////////////////////////////////////////////////
// store

public function store_show()
{
    $stores = Store::get();
    return view('store.show' , ['stores' => $stores]);
}
public function store_create_get()
{   
    return view('store.create');
}
public function store_create(Request $request) {
    
    $store = Store::create ( [ 		
            'store_name' => $request ['store_name'],
            'sell_name' => $request ['sell_name'],
            'unit' => $request ['unit']
    ] );    
    session()->flash('message', 'New store Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/store/index" );
}

public function store_edit_get($store_id){
    $store = DB::table('stores')->where('id', '=',$store_id)->first();
    return view('store.edit',[
                            'store' => $store
                            ]);
}
public function store_edit_post(Request $request){
    $store_id = $request ['store_id'];
    $store_name = $request ['store_name']; 
    $sell_name = $request ['sell_name']; 
    $unit = $request ['unit'];
   

    DB::table('stores')
        ->where('id', $store_id)
        ->update(['store_name' => $store_name,
                  'sell_name' => $sell_name,
                  'unit' => $unit,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'store Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/store/edit/$store_id" );
}



public function store_delete($store_id){
    
    $store = Store::find($store_id);
    $store->delete();
    return redirect ( "/store/index");
}


// store_branch 

public function store_branch_show()
{
    $store_branches = Store_Branch::get();
    return view('store.store_branch_show' , ['store_branches' => $store_branches]);
}

public function store_branch_create_get() {
    $branches = Branch::get();
    $stores = Store::get();
    return view('store.store_branch_create', ['stores' => $stores , 'branches' => $branches  ]);
}

public function store_branch_create_post(Request $request) {
    $store_id = $request ['store_id'];
    $branch_id = $request ['branch_id'];
    $quantity= $request ['quantity'];
    $unit_price = $request['unit_price'];
    
    $row = DB::table('store_branch')->where('store_id', '=',$store_id)->where('branch_id', '=',$branch_id)->first();
    if ($row){
        session()->flash('message', 'Store Sell Already Exist ');
        session()->flash('type', 'error');
        return redirect ( "/store/branch/create" );
    } 
    else {
    $store = Store_Branch::create ( [ 		
            'quantity' => $quantity,
            'store_id' => $store_id,
            'branch_id' => $branch_id,
            'unit_price'=>$unit_price
    ] );   
   }
    session()->flash('message', 'New Sell store Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/store/branch/index" );
}


public function store_branch_edit_get( $store_branch_id) {
    
$store_branch = DB::table('store_branch')->where('id',$store_branch_id)->first();
    
    return view('store.store_branch_edit', ['store_branch' => $store_branch  ]);
}


public function store_branch_edit_post(Request $request) {
    $store_branch_id = $request ['store_branch_id'];
    $quantity= $request ['quantity'];
    $unit_price = $request['unit_price'];
    
     $store = DB::table('store_branch')
        ->where('id', $store_branch_id)
        ->update(['quantity' => $quantity,
                  'unit_price' => $unit_price,
         'updated_at' => Carbon::now()]);
         
    session()->flash('message', 'Store Branch updated  Successfully');
    session()->flash('type', 'success');
    return redirect ( "/store/branch/index" );
}




}
