<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth; 

class RecyclerReportController  extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        
        return view('recyclerreport.create');
        
    }


     // ajax 
     public function get_customers($from , $to){
        
        
       $mains = Main::with("customer")->where('customer_id','!=',NULL)
       //->whereBetween( 'created_at', [$from, $to] )
       ->whereDate('created_at','>=',$from)
       ->whereDate('created_at','<=',$to)
       ->groupBy('customer_id')
       ->get();
     
         
        return \Response::json(['customers_' => $mains, ]);

    }

     // ajax 
     public function get_suppliers($customer_id, $from , $to){
        
        $mains = Main::with("supplier")->where('customer_id',$customer_id)
        //->whereBetween( 'created_at', [$from, $to] )
        ->whereDate('created_at','>=',$from)
        ->whereDate('created_at','<=',$to)
        ->groupBy('supplier_id')
        ->get();
     
         
        return \Response::json(['suppliers_' => $mains, ]);

    }

    // ajax
    public function get_wastes($arr_of_suppliers , $customer_id, $from , $to ){
        
        $arr = explode(',', $arr_of_suppliers); // convert string to array
        $mains = Main::with("waste")->where('customer_id',$customer_id)
                                    ->whereIn('supplier_id', $arr)
                                           ->whereDate('created_at','>=',$from)
                                           ->whereDate('created_at','<=',$to)
                                    ->groupBy('waste_id')
                                    ->get();
        
        return \Response::json(['wastes_' => $mains, ]);

    }

    

    




    public function recycler_report_create_post(Request $request) {
    
        
        $customer_id = $request ['customer_id'];
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $selected_suppliers = $request ['resycler_suppliers']; 
        $selected_wastes = $request ['resycler_wastes']; 

        
        $customer = DB::table('customers')->where('id', '=',$customer_id)->first();

        $suppliers = Supplier::whereIn('id', $selected_suppliers)->get();
        
       
        $mains = Main::with("waste", "supplier")->where('customer_id',$customer_id)
        ->whereIn('supplier_id', $selected_suppliers)
        ->whereIn('waste_id', $selected_wastes)
         ->whereDate('created_at','>=',$dateFrom)
         ->whereDate('created_at','<=',$dateTo)
        ->get();

        $sum_kg=0;  // kg
        $sum_num=0;  // عدد
        foreach ($mains as $main) {
            if( $main->waste->unit == 'كجم' ){
                $sum_kg = $sum_kg + $main->quantity;
            }else{
                $sum_num = $sum_num + $main->quantity;
            } 
        }
         

         $to = "ahmed.said18194@gmail.com";
         //$subject = "Egwaste Tracking From ". $dateFrom ."  ".$dateTo;
         
         $subject = "Egwaste Recycler For : ".$customer->name. "From : ". $dateFrom ."  To : ".$dateTo;
         $message = "<b>".Auth::user()->name."</b>";

         $header = "From:ahmed.said18194@gmail.com \r\n";
         $header .= "MIME-Version: 1.0\r\n";
         $header .= "Content-type: text/html\r\n";
         
         $retval = mail ($to,$subject,$message,$header);
         
        return view('recyclerreport.show', [
            'customer'=>$customer->name,
            'mains'=>$mains,
            //'mains'=>[],
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo,
            'sum_kg'=>$sum_kg,
            'sum_num'=>$sum_num,
            'selected_suppliers'=>$suppliers,
        ]);
        
    }

    




}
