<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\Price;
use App\Waste;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use App\Actions;
use Auth;
class PriceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function price_edit_get()
    {
        $wastes =  DB::table("waste")->get(); 
        
        ///////////////// action /////////////////

        $subject = "Borsa Show Page , Show All Wastes in Edit Form Mode  ";
        $action = "Borsa Edit_Git Page"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
        
        return view('price.edit' , ['wastes' => $wastes  ]);
    }

    
    public function price_show()
    {
        $wastes =  DB::table("waste")->get(); 
        
        ///////////////// action /////////////////

        $subject = "Borsa Show Page , Show All Wastes in Table Form Mode  ";
        $action = "Borsa Show Page"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
        
        
        return view('price.show' , ['wastes' => $wastes  ]);
    }

    public function price_edit_post(Request $request)
    {
               
       try {

        $json = json_encode($request->except('_token'), JSON_NUMERIC_CHECK );
        $array = json_decode($json, TRUE);

        foreach ( $array as $waste_id=>$new_waste_price  ) {
             
            DB::table('waste')
            ->where('id', $waste_id)
            ->update([
                    'price' => $new_waste_price,
                    'updated_at' => Carbon::now()
            ]);
        }
        
        
                ///////////////// action /////////////////

        $subject = "Borsa Edit Request for all wastes from the Edit Page , ";
        $action = "Borsa Edit Price Request For All Wastes "  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
        session()->flash('type', 'success');
        return redirect ( "/price/edit_get" );

      } catch (\Exception $e) {
      
        session()->flash('message', $e->getMessage());
        session()->flash('type', 'danger');
        return redirect ( "/price/edit_get" );

      }
    }

}
