@extends('layouts.masterHome2')

@section('content')

   

 
   
    <div class="invoice p-3 mb-3">
              <!-- title row -->
              <div class="row">
                <div class="col-12">
                  <h4>
                     
                    <small class="float-right">Date: {{$invoice->created_at->format('d/m/Y')}}</small>
                  </h4>
                </div>
                <!-- /.col -->
              </div>
              <!-- info row -->
              <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                <a href="{{ url('#') }}" class="brand-link">
                  <img src='{{asset("theme/dist/img/logo1.png")}}' alt="Egwaste"  style="height: 74px;"   >
                  <span class="brand-text font-weight-light">&nbsp;</span>
                </a>

                   
                </div>
                <!-- /.col -->
                <div class="col-sm-4 invoice-col">
                  To
                  <address>
                    <strong>{{$invoice->client->name}}</strong><br>
                    {{$invoice->client->address?$invoice->client->address:""}}<br>
                    {{$invoice->client->ct ?$invoice->client->ct:"" }} , {{ $invoice->client->bd?$invoice->client->bd:""}}<br>
                    Phone: {{$invoice->client->mobile ?$invoice->client->mobile :"" }}<br>
                    Email: {{$invoice->client->email?$invoice->client->email:""}}
                  </address>
                </div>
                <!-- /.col -->
                <div class="col-sm-4 invoice-col">
                  <b>Invoice #{{$invoice->id}}</b><br>
                  <br>
                 
                  <b>Payment Due:</b> {{$invoice->created_at->format('d/m/Y')}}<br>
                  <b>Account:</b> {{$invoice->branch->name}} </b>
                  <div >
                  @php
                    $start_datetime = new DateTime($invoice->created_at); 
                    $diff = $start_datetime->diff(new DateTime(date('Y-m-d H:i:s'))); 
                     
                  @endphp

                  @if ( $invoice->confirmed == NULL &&  $diff->h < 8 && $diff->d == 0 )
                    <a href='{{url("/invoice/save/$invoice->id")}}'   onclick="return confirm('Are you sure you want to Confirm this invoice?'); " id="confirm" class="btn" style="background-color:#2C4E71;color:#FFF;margin-top: 10px;width: 150px;"  >تأكيد </a>
                  @endif
                  @if ( $invoice->confirmed == NULL && ($diff->h >= 8 || $diff->d > 0  )  )
                    <a href='{{url("/invoice/delete/$invoice->id")}}'  onclick="return confirm('Are you sure you want to Delete this invoice?'); " id="delete" class="btn" style="background-color:#2C4E71;color:#FFF;margin-top: 10px;width: 150px;"  > Delete</a>
                  @endif
                  

                  </div>
                </div>
                <!-- /.col -->
              </div>
              <!-- /.row -->

              <!-- Table row -->
              <div class="row">
                <div class="col-12 table-responsive">
                  <table class="table table-striped">
                    <thead>

                    <tr>
                      <th>Qty</th>
                      <th>Product</th>
                      <th>Item Price</th>
                      <th>Sub total</th>
                    </tr>
                    </thead>
                    <tbody>
                    
                    @foreach( $invoice_items as $key=>$item )
                    <tr>
                      <td>{{$item->item_amount}}</td>
                      <td>{{$item->sell_store->store->sell_name}}</td>
                      <td>{{$item->item_price}}</td>
                      <td>{{$item->item_price* $item->item_amount }}</td>
                    </tr>
                     @endforeach
                    </tbody>
                  </table>
                </div>
                <!-- /.col -->
              </div>
              <!-- /.row -->


              


              <div class="row">
                <!-- accepted payments column -->
              
                <div class="col-6">
                  <p class="lead">Payment Methods</p>

                  <div class="table-responsive">
                    <table class="table">
                    @foreach ( $invoice_payments as $invoice_payment)  
                    <tr>
                        <th >{{ $invoice_payment->payment_method->name}}</th>
                        <td>{{ $invoice_payment->pay}}</td>
                         @if($invoice_payment->cheque_id )
                          <td>  #{{ $invoice_payment->cheque->serial}}</td>
                          <td> {{ $invoice_payment->cheque->bank->name}}</td>
                          <td> {{ $invoice_payment->cheque->date}}</td>
                          @else
                          <td></td><td></td><td></td>
                        @endif
                      </tr>
                      @endforeach
                    </table>
                  </div>
                </div>
               
                <div class="col-2"></div>
                <div class="col-4">
                  <p class="lead">Amount Due {{$invoice->created_at->format('d/m/Y')}}</p>

                  <div class="table-responsive">
                    <table class="table">
                      <tr>
                        <th style="width:50%">Subtotal:</th>
                        <td> {{$invoice->discount_type == "num" ?$invoice->total_price + $invoice->discount   :
                          ($invoice->total_price * $invoice->discount) /(100-$invoice->discount)+$invoice->total_price 
                        }}</td>
                      </tr>
                      <tr>
                        <th>Discount  ({{$invoice->discount }} {{$invoice->discount_type=="num"?"pound":"%"}})</th>
                        <td><del>{{$invoice->discount_type=="num"? $invoice->discount :
                          ($invoice->total_price * $invoice->discount) /(100-$invoice->discount)
                        }} </del></td>
                      </tr>
                      
                     
                      
                      <tr>
                        <th>Total:</th>
                        <td>{{$invoice->total_price}}</td>
                      </tr>
                      
                    </table>
                  </div>
                </div>
                <!-- /.col -->
               
                <!-- /.col -->
              </div>
              <!-- /.row -->

               
   
   
    @endsection
