<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Waste extends Model
{
    public $timestamps = true;
    protected $table = 'waste';
    protected $fillable = [
       'name','unit','price','tax', 'class_id','classifications_id','groups_id','reuse_methods_id','created_at','updated_at','store_id'
    ];

    public function class_()
    {
        return $this->belongsTo('App\Class_', 'class_id');
    }
    public function classification()
    {
        return $this->belongsTo('App\Classification', 'classifications_id');
    }
    public function group()
    {
        return $this->belongsTo('App\Group', 'groups_id');
    }
    public function res_method()
    {
        return $this->belongsTo('App\RecycleMethod', 'reuse_methods_id');
    }


    public function suppliers()
    {
        return $this->belongsToMany(Supplier::class,'supplier_waste');
    }

    public function store()
    {
        return $this->belongsTo('App\Store','store_id');
    }

}

