<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','is_supplier','is_supervisor','is_admin','is_superadmin','show_','edit_','create_','delete_','approve_','branch_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    public function supplier()
    {
        return $this->belongsTo('App\Supplier', 'is_supplier');
    }
}
