<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Invoice_Item extends Model
{
    public $timestamps = true;
    protected $table = 'invoice_items';
    protected $fillable = [
       'sell_store_id','invoice_id','created_at','updated_at','item_price','item_amount'
    ];


    public function sell_store()
    {
        return $this->belongsTo('App\Store_Branch', 'sell_store_id');
    }

    public function invoice()
    {
        return $this->belongsTo('App\Invoice', 'invoice_id');
    }

    
}

