<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    public $timestamps = true;
    protected $table = 'invoice';
    protected $fillable = [
       'client_id','created_at','updated_at','discount','discount_type','total_price','confirmed','branch_id','adds'
    ];


    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }

    public function items()
    {
        return $this->hasMany('App\Invoice_Item');
    }

    public function payments()
    {
        return $this->hasMany('App\Invoice_Payment');
    }
    public function branch()
    {
        return $this->belongsTo('App\Branch');
    }
    
}

