<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Client;
use App\Invoice;
use App\Invoice_Item;
use App\Invoice_Payment;
use App\Cheque;
use App\Bank;
use App\Client_Sheet;
use App\Receipt;


class VoucherController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    
//////////////////////////////////////////////////
// سند القبض ///////////////////////////////////

public function receipt_show()
{
    $branch_id = Auth::user()->branch_id ;
    $receipts = Receipt::where('branch_id', $branch_id )->get();
    return view('voucher.show_receipts' , ['receipts' => $receipts]);

}


public function receipt_create_get()
{
    $branch_id = Auth::user()->branch_id ;
    $clients = Client::select('id', 'name')->where('branch_id',$branch_id)->get();
    $banks = Bank::select('id', 'name')->get();
    
    
    $accounts = Safe_Account::with('payment_method')->where('branch_id',$branch_id)->get();

    return view('voucher.create_receipt' , ['clients' => $clients, 'banks' => $banks , "accounts"=>$accounts ]);

}




public function receipt_create_post( Request $request)
{
    $branch_id = Auth::user()->branch_id ;
    $cheque_or_deposite = $request ['cheque_or_deposite'];

 
    $cheque=NULL;
    if ( $cheque_or_deposite ) {
        $cheque = Cheque::create ( [ 		
            'serial'=> $request ['serial_'] ,
            'bank_id'=> $request ['bank_id'] ,
            'date'=>$request ['date_'],
            'client_id' => $request ['client_id'],
            'invoice_id'=>NULL,
            "pay"=>$request ['pay'],
            "branch_id"=>$branch_id,
            "cheque_or_deposite"=>$cheque_or_deposite=="cheque"?"cheque":"deposite"
            ]);
    }
    
    // سند القبض
    $receipt = Receipt::create ( [ 		
        'client_id' => $request ['client_id'],
        'note1' => $request ['note1'],
        'note2' => $request ['note2'],
        'pay' => $request ['pay'],
        'cheque_id' => $cheque ? $cheque->id : NULL,
        "branch_id"=>$branch_id,
        'safe_account_id'=>$request ['safe_account_id']
    ] );

    // حساب العميل 
    Client_Sheet::insert ( 
        [ 		
            'leeh' => $request ['pay'],
            'aleeh' => 0 ,
            'client_id' => $request ['client_id'],
            'invoice_id'  => NULL,
            'receipt_id'  => $receipt->id
        ]);


    //
    // increase safes 
    
       
        // increase  safe account 
        DB::table('safe_accounts')
        ->where('id', $receipt->safe_account_id)
        ->update([ 'balance' => DB::raw("balance+$receipt->pay"),
                'updated_at' => Carbon::now()
        ]);
    
    //

    session()->flash('message', 'New Recipt Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/receipt/create" );

}



public function print ( $voucher_id ){
    $voucher = Receipt::where('id',$voucher_id)->first();
    return view('voucher.print' ,  ['voucher' => $voucher  ]);  
}





}
