<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Client;
use App\Invoice;
use App\Invoice_Item;
use App\Invoice_Payment;
use App\Cheque;
use App\Bank;
use App\Client_Sheet;
use App\Payment_Voucher;
use App\Trust;
use App\Safe_Back;
use App\Safe_History;


class TrustController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


public function trust_show_tie()
{
    $trusts = Trust::where('type','عهدة مربوطة بمبلغ')->get();
    return view('trust.show_tie' , ['trusts' => $trusts]);

}

public function trust_show_not_tie()
{
    $trusts = Trust::where('type','عهدة غير مربوطة بمبلغ')->get();
    return view('trust.show_not_tie' , ['trusts' => $trusts]);

}

public function create_get()
{
    return view('trust.create');
}

public function create_post( Request $request)
{    
    $branch_id = Auth::user()->branch_id ;
    $user_id = Auth::user()->id ; // admin_id
    $trust = Trust::create ( [ 	
        'name' => $request ['name'],
        'type' => $request['type'],
        'branch_id'=>$branch_id,
        'user_id'=>$user_id,
        'amount'=>$request ['amount']?$request ['amount']:NULL,
        'approve'=>$request ['amount']?"Waiting":"Approved", // if has amount then make by defult not approved
    ] );
    session()->flash('message', 'New trust Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/trust/create" );
}


public function edit_get($trust_id)
{
    $trust = Trust::where("id", $trust_id )->first();
    return view('trust.edit' ,  ['trust'=>$trust ]);

}

public function edit_post( Request $request)
{    
    $trust_id = $request ["trust_id"];
    $name = $request ["name"];

    DB::table('trusts')
    ->where('id', $trust_id)
    ->update([ 'name' =>$name, 
            'updated_at' => Carbon::now()
    ]);
    session()->flash('message', ' trust Updatted Successfully');
    session()->flash('type', 'success');
    return redirect ( "/trust/edit/$trust_id" );

}



public function invoices_amount_get($trust_id)
{
    $trust = Trust::where("id", $trust_id )->first();
    return view('trust.invoices_amount' ,  ['trust'=>$trust ]);

}

public function invoices_amount_post( Request $request)
{    
    $trust_id = $request ["trust_id"];
    $total_invoices = $request ["total_invoices"];

    DB::table('trusts')
    ->where('id', $trust_id)
    ->update([ 'total_invoices' =>$total_invoices,
            'updated_at' => Carbon::now()
    ]);
    session()->flash('message', ' trust Total invoices Added  Successfully');
    session()->flash('type', 'success');
    return redirect ( "/trust/invoices_amount/$trust_id" );

}


public function increment_amount_get($trust_id)
{
    $trust = Trust::where("id", $trust_id )->first();
   
    return view('trust.increment_amount' ,  ['trust'=>$trust ]);

}

public function increment_amount_post( Request $request)
{    
    $trust_id = $request ["trust_id"];
    $amount = $request ["increment_amount"];

    DB::table('trusts')
    ->where('id', $trust_id)
    ->update([ 'increment_amount' =>$amount,'increment_approve'=>"Waiting",
            'updated_at' => Carbon::now()
    ]);
    session()->flash('message', ' trust increment_amount Added  Successfully');
    session()->flash('type', 'success');
    return redirect ( "/trust/increment_amount/$trust_id" );

}



public function trust_safe_back_get($trust_id)
{
    $trust = Trust::where("id", $trust_id )->first();
   
    return view('trust.safe_back' ,  ['trust'=>$trust ]);

}

public function trust_safe_back_post( Request $request)
{    
    $branch_id = Auth::user()->branch_id ;
    $trust_id = $request ["trust_id"];
    $pay_back = $request ["pay_back"];
    $trust = Trust::where("id", $trust_id )->first();

    $back = Safe_Back::create ( [
        'pay_back'=>$pay_back,
        'trust_id'=>$trust_id
    ] );


    // get payment mrthod نقدي 
    $payment_method = Payment_Method::where('name','نقدي')->first();
    $safe_account =  Safe_Account::where('branch_id',$branch_id)->where('payment_method_id',$payment_method->id)->first();
    
    Safe_History::insert ( 
        [ 	'balance_before' => $safe_account->balance,
            'balance_after' =>  $safe_account->balance + $pay_back ,
            'descreption' => "Pay back to Safe Account  $safe_account->id by $pay_back via trust not tie num $trust_id )",
            'user_id' => Auth::user()->id,
            'receipt_id'=>NULL,
            'safe_account_id'=>$safe_account->id
        ]);

        // increase  safe account 
        DB::table('safe_accounts')
        ->where('id', $safe_account->id)
        ->update([ 'balance' => DB::raw("balance+$pay_back"),
                'updated_at' => Carbon::now()
        ]);



    session()->flash('message', ' Pay Back  Successfully');
    session()->flash('type', 'success');
    if ( $trust->type == "عهدة غير مربوطة بمبلغ") {
        return redirect ( "/trust/not_tie_details/$trust_id" );
    }

    return redirect ( "/trust/tie_details/$trust_id" );
}



public function trust_end_get ($trust_id){

    DB::table('trusts')
    ->where('id', $trust_id)
    ->update([ 'status' =>"END",'updated_at' => Carbon::now()]);
    session()->flash('message', ' trust End  Successfully');
    session()->flash('type', 'success');
    return redirect ( "/trust/not_tie_details/$trust_id" );
}






public function trust_not_tie_details($trust_id)
{ 
    
    $trust = Trust::where("id", $trust_id )->first();

    $sendats = Payment_Voucher::where("trust_id",$trust_id)->get();

    $total_pay = Payment_Voucher::where('trust_id' ,$trust_id)->where('approve',"approved")->sum('pay');

    $total_pay_back = Safe_Back::where('trust_id' ,$trust_id)->sum('pay_back');

    return view('trust.details_not_tie' ,  ['trust'=>$trust, 'sendats'=>$sendats, "total_pay"=>$total_pay, 'total_pay_back'=>$total_pay_back]);
}


public function trust_tie_details($trust_id)
{ 
    
    $trust = Trust::where("id", $trust_id )->first();

    $sendats = Payment_Voucher::where("trust_id",$trust_id)->get();

    $total_pay = Payment_Voucher::where('trust_id' ,$trust_id)->where('approve',"approved")->sum('pay');

    $total_pay_back = Safe_Back::where('trust_id' ,$trust_id)->sum('pay_back');
    
    return view('trust.details_tie' ,  ['trust'=>$trust, 'sendats'=>$sendats, "total_pay"=>$total_pay, 'total_pay_back'=>$total_pay_back]);
}


}
