<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Store_Branch;
use App\Store_History;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;

class SortController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function sort_get($main_id)
    {
        $main = Main::with('supplier' , 'waste' , 'user') ->where( 'id', $main_id )->first();
        $main_sell_store_id = $main->sell_store_id;
        $sorts = Sort::where( 'main_id', $main_id )->get();
        $sell_stores= Store_Branch::where( 'id',"!=", $main_sell_store_id )->get();
        
        $sorts_sum_quantity = 0 ;
        foreach ( $sorts as $sort ) {
            $sorts_sum_quantity = $sorts_sum_quantity + $sort->quantity; 
        } 
        return view('sort.sort' , ['main' => $main , 'sorts'=>$sorts, 'sell_stores'=>$sell_stores , 'sorts_sum_quantity'=>$sorts_sum_quantity] );
    }



    public function sort_post(Request $request)
    {
        $sell_store_id = $request['sell_store_id'];
        $quantity = $request['quantity'];
        $main_id = $request['main_id'];
        $main_sell_store_id = $request['main_sell_store_id'];
        
        // get the two sell stores to get quantity nedded in store history 
        $main_sell_store = Store_Branch::where( 'id', $main_sell_store_id )->first();
        $sort_sell_store = Store_Branch::where( 'id', $sell_store_id )->first();

        $sort = Sort::where( 'main_id', $main_id )->where( 'sell_store_id', $sell_store_id )->first();
        if ($sort){
            DB::table('sort')
                ->where( 'id', $sort->id )
                ->update([ 'quantity' => DB::raw("quantity+$quantity"),
                'updated_at' => Carbon::now()
        ]);
        }else{
        Sort::create ( [ 		
            'main_id' => $main_id,
            'sell_store_id' => $sell_store_id,
            'quantity' => $quantity

        ] );
        }


        // decrease from sell_store
        DB::table('store_branch')
        ->where('id', $main_sell_store_id)
        ->update([ 'quantity' => DB::raw("quantity-$quantity"),
                'updated_at' => Carbon::now()
        ]);

        // increase 
        DB::table('store_branch')
        ->where('id', $sell_store_id)
        ->update([ 'quantity' => DB::raw("quantity+$quantity"),
                'updated_at' => Carbon::now()
        ]);

        // decrease
        Store_History::insert ( 
            [ 		
                'quantity_before' => $main_sell_store->quantity,
                'quantity_after' =>  $main_sell_store->quantity - $quantity ,
                'descreption' => "Sort Carta num  $main_id Decrease  sell store num $main_sell_store_id by $quantity )",
                'main_id'  => $main_id,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$main_sell_store_id
            ]);

            //increase 
        Store_History::insert ( 
            [ 		
                'quantity_before' => $sort_sell_store->quantity,
                'quantity_after' =>  $sort_sell_store->quantity + $quantity ,
                'descreption' => "Sort Carta num  $main_id Increase  sell store num $sell_store_id by $quantity )",
                'main_id'  => $main_id,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store_id
            ]);



        return redirect ( "/main/sort/$main_id" );
    }


}
