<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Client;
use App\Invoice;
use App\Invoice_Item;
use App\Invoice_Payment;
use App\Cheque;
use App\Bank;
use App\Client_Sheet;
use App\Receipt;
use App\Safe_History;

class InvoiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    
//////////////////////////////////////////////////
// Invoice
public function invoice_show()
{
    $branch_id = Auth::user()->branch_id ;
    $clients = Client::select('id', 'name')
    ->where('branch_id' ,$branch_id )
    ->where('client_state' , '=' , 'active')
    ->get();
    return view('invoice.show' , ['clients' => $clients]);

}

public function list_all_invoice()
{
    $branch_id = Auth::user()->branch_id ;
    $invoices = Invoice::where('branch_id' ,$branch_id )->get();
    return view('invoice.invoice_show' , ['invoices' => $invoices]);

}
public function details($invoice_id)
{

    $invoice = Invoice::where('id' ,$invoice_id)->first();
    $invoice_items = Invoice_Item::where('invoice_id' ,$invoice_id)->get();
    $invoice_payments = Invoice_Payment::where('invoice_id' ,$invoice_id)->get();
    return view('invoice.details' , ['invoice' => $invoice , "invoice_items"=>$invoice_items, "invoice_payments"=>$invoice_payments
]);

}



public function get_sell_stores(){
    $branch_id = Auth::user()->branch_id ;
    $sell_stores = Store_Branch::with('store')->where('branch_id',$branch_id)->where('locked',"unlocked")->get();
    return \Response::json(['sell_stores' => $sell_stores ]);
}


public function get_safe_accounts(){
    $branch_id = Auth::user()->branch_id ;
    $accounts = Safe_Account::with('payment_method')->where('branch_id',$branch_id)->get();
    $banks = Bank::get();
    return \Response::json(['accounts' => $accounts, 'banks' => $banks  ]);
}

 
public function invoice_create($list , $pay_list, $client) {
    
   $products = json_decode($list);
   $payments = json_decode($pay_list);
   $client = json_decode($client);

   $branch_id = Auth::user()->branch_id ;

   $invoice = Invoice::create ( [ 		
    'discount'=> $client->discount ,
    'discount_type'=> $client->discount_type ,
    'client_id' => $client->client_id ,
    'total_price'=>$client->total_price,
    'branch_id'=>$branch_id
    ]); 
////////////////////////////////////////////////////////
    $product_arr =[];
    foreach ( $products as $product ) {
        $arr = ["sell_store_id"=>$product->sell_store_id, "item_price"=>$product->price,"item_amount"=>$product->quantity,"invoice_id"=>$invoice->id];
        $product_arr[]=$arr;
    }
    Invoice_Item::insert($product_arr);
//////////////////////////////////////////////////////////


    $pay_arr1 =[];
    $pay_arr2 =[];

    // add snad kabd
    $total_payment= 0 ;
    foreach ( $payments as $payment ) {
        $total_payment = $total_payment + $payment->payamount ; 
    }
    if ( $total_payment ) {
    $receipt = Receipt::create ( [ 		
        'client_id' => $client->client_id,
        'note1' => "invoice ".$invoice->id,
        'note2' => "invoice ".$invoice->id,
        'pay' => $total_payment,
        'invoice_id' =>$invoice->id,
        'branch_id'=>$branch_id
    ]);
    }
    foreach ( $payments as $payment ) {
        if ( $payment->cheqserial_ == ""){
            $pay_arr1[] = ["invoice_id"=>$invoice->id, 
                           "payment_method_id"=>$payment->payment_method_id,
                           "cheque_id"=>NULL,
                           "safe_account_id"=>$payment->safe_account_id,
                           "pay"=>$payment->payamount,
                           "receipt_id"=>$receipt->id,
                           "created_at"=>$invoice->created_at
                        ];
        }else {
            $cheque = Cheque::create ( [ 		
                'serial'=> $payment->cheqserial_ ,
                'bank_id'=> $payment->cheqbank_ ,
                'date'=>$payment->cheqdate_,
                'client_id' => $client->client_id,
                'invoice_id'=>$invoice->id,
                "pay"=>$payment->payamount,
                "branch_id"=>$branch_id,
                "created_at"=>$invoice->created_at,
                "cheque_or_deposite"=>$payment->payment_method_name=="شيك"?"cheque":"deposite"
                ]);
            $pay_arr2[] = ["invoice_id"=>$invoice->id, 
            "payment_method_id"=>$payment->payment_method_id,
            "cheque_id"=>$cheque->id,
            "safe_account_id"=>$payment->safe_account_id,
            "pay"=>$payment->payamount,
            "receipt_id"=>$receipt->id,
            "created_at"=>$invoice->created_at
         ];

        }
    }

    Invoice_Payment::insert($pay_arr1);
    Invoice_Payment::insert($pay_arr2);

   // return redirect ( "/invoice/details/$invoice->id" );
  
   return \Response::json(['list' => $products , 'pay_list' => $payments , 'client' => $client , 'state'=>200 , "invoice_id"=>$invoice->id ]);

}

public function invoice_save($invoice_id)
{

    $invoice = Invoice::where('id' ,$invoice_id)->first();
    $invoice_items = Invoice_Item::where('invoice_id' ,$invoice_id)->get();
    $invoice_payments = Invoice_Payment::where('invoice_id' ,$invoice_id)->get();

    $total_price = 0;
    $total_pay = 0;
    // reduce sell stores 
    foreach ( $invoice_items as $item ){
        $total_price=$total_price + ( $item->item_price * $item->item_amount ) ;
        // decrease  sell_store
        $sell_store = Store_Branch::where( 'id', $item->sell_store_id)->first();
        DB::table('store_branch')
        ->where('id', $item->sell_store_id)
        ->update([ 'quantity' => DB::raw("quantity-$item->item_amount"),
                    'last_sell_price'=>$item->item_price,
                'updated_at' => Carbon::now()
        ]);
        // decrease
        Store_History::insert ( 
            [ 	'quantity_before' => $sell_store->quantity,
                'quantity_after' =>  $sell_store->quantity - $item->item_amount ,
                'descreption' => "invoice num  $invoice_id Decrease  sell store num $sell_store->id by $item->item_amount )",
                'main_id'  => NULL,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store->id
            ]);
    }


    // increase safes 
    foreach ( $invoice_payments as $payment ){
        $total_pay = $total_pay + $payment->pay;
        // increase  safe account 

        
        $safe_account = Safe_Account::where( 'id', $payment->safe_account_id)->first(); 
        Safe_History::insert ( 
            [ 	'balance_before' => $safe_account->balance,
                'balance_after' =>  $safe_account->balance + $payment->pay ,
                'descreption' => "invoice num  $invoice_id Increase  Safe Account  $safe_account->id by $payment->pay )",
                'invoice_id'  => $invoice_id,
                'user_id' => Auth::user()->id,
                'safe_account_id'=>$safe_account->id
            ]);
        
        DB::table('safe_accounts')
        ->where('id', $payment->safe_account_id)
        ->update([ 'balance' => DB::raw("balance+$payment->pay"),
                'updated_at' => Carbon::now()
        ]);
    }


    
    if ($invoice->discount_type == "num"  ) {
        $total_price = $total_price - $invoice->discount;
    }else {
        $total_price = $total_price - ( ($invoice->discount * $total_price) / 100 ) ;
    }




    // client previous sheet
    $leeh =  Client_Sheet::where('client_id' ,$invoice->client_id)->sum('leeh');
    $aleeh = Client_Sheet::where('client_id' ,$invoice->client_id)->sum('aleeh');
    $client_previos_account=0;
    $client_previos_string = "";
    if ( $leeh > $aleeh ) {
        $client_previos_account = $leeh - $aleeh ; 
        $client_previos_string= "له";
    }else if ( $aleeh > $leeh ) { 
        $client_previos_account = $aleeh - $leeh ; 
        $client_previos_string ="عليه";
    }

    ////////////////////////////////////
    Client_Sheet::insert ( 
        [ 		
            'leeh' => $total_pay,
            'aleeh' =>  $total_price ,
            'client_id' => $invoice->client_id,
            'invoice_id'  => $invoice_id
        ]);
//////////////////////////////////////////

// client previous sheet
$leeh =  Client_Sheet::where('client_id' ,$invoice->client_id)->sum('leeh');
$aleeh = Client_Sheet::where('client_id' ,$invoice->client_id)->sum('aleeh');
$client_current_account=0;
$client_current_string = "";
if ( $leeh > $aleeh ) { 
    $client_current_account = $leeh - $aleeh ; 
    $client_current_string= "له";
}else if ( $aleeh > $leeh ) { 
    $client_current_account = $aleeh - $leeh ; 
    $client_current_string ="عليه";
}

//// confirm invoice 

DB::table('invoice')
->where('id', $invoice_id)
->update([ 'confirmed' =>"confirmed",
        'updated_at' => Carbon::now()
]);
//// end confirm invoice 


    return view('invoice.print' , ['invoice' => $invoice , "invoice_items"=>$invoice_items, "invoice_payments"=>$invoice_payments , 
    "client_previos_account"=>$client_previos_account ,"client_previos_string"=>$client_previos_string,
    "client_current_account"=>$client_current_account ,"client_current_string"=>$client_current_string,"print"=>"yes",
    "total_pay"=>$total_pay
]);

}

public function delete_invoice ( $invoice_id ) {

    DB::table('invoice')
        ->where('id', $invoice_id)
        ->update([ 'confirmed' =>"deleted",
        'updated_at' => Carbon::now()
    ]);
    return redirect ( "/invoice/show" );
}



public function cheque_show()
{
    $branch_id = Auth::user()->branch_id ;
    $cheques = Cheque::where('cheque_or_deposite','=',"cheque")
    ->where('branch_id', $branch_id)
    ->get();
    return view('cheque.show_cheques' , ['cheques' => $cheques]);

}

public function cheque_details($cheque_id)
{
    $branch_id = Auth::user()->branch_id ;
    $cheque = Cheque::where('cheque_or_deposite','=',"cheque")
    ->where('branch_id', $branch_id)
    ->where('id', $cheque_id)
    ->first();
    return view('cheque.details' , ['cheque' => $cheque]);

}

public function cheque_change_status( Request $request)
{

    $cheque_id = $request ['cheque_id'];
    
    $branch_id = Auth::user()->branch_id ;
    $cheque = Cheque::where('cheque_or_deposite','=',"cheque")
    ->where('branch_id', $branch_id)
    ->where('id', $cheque_id)
    ->first();
    
     
     // sand sarf 
    if ($cheque->invoice_id == NULL && $cheque->client_id == NULL){
        
        $status = $request ['status'];
        DB::table('cheque')
        ->where('id', $cheque_id)
        ->update([ 'status' => $status,
                'updated_at' => Carbon::now()
        ]);
    
        return redirect ( "/cheque/details/$cheque_id" );
        
    }
    
   // add new row in the client_sheet table with the 
   // same date of the client sheet row ( that related to invoice or receipt)
   // to calculate with priviaus leeh and aleeh and current leeh and alee with < <=
   
    $client_sheet_created_at = null ;
    if ($cheque->invoice_id ) {
        $client_sheet_created_at = Client_Sheet::where('client_id',$cheque->client_id)
                                                ->where('invoice_id',$cheque->invoice_id)->first()->created_at;
    }else {

        $receip_id = Receipt::where('client_id',$cheque->client_id)
                            ->where('cheque_id',$cheque->id)->first()->id;
                                                
        $client_sheet_created_at = Client_Sheet::where('client_id',$cheque->client_id)
                                                ->where('receipt_id',$receip_id)->first()->created_at;
    }

    Client_Sheet::insert ( 
        [ 		
            'created_at'=>$client_sheet_created_at,
            'leeh' => 0,
            'aleeh' => $cheque->pay ,
            'client_id' => $cheque->client_id,
            'invoice_id'  => NULL,
            'refused_cheque'=>$cheque->pay
        ]);
    $status = $request ['status'];
    DB::table('cheque')
        ->where('id', $cheque_id)
        ->update([ 'status' => $status,
                'updated_at' => Carbon::now()
        ]);
    
        return redirect ( "/cheque/details/$cheque_id" );
}


public function deposites_show()
{
    $branch_id = Auth::user()->branch_id ;
    $deposites = Cheque::where('cheque_or_deposite','=',"deposite")
    ->where('branch_id', $branch_id)
    ->get();
    return view('cheque.show_deposites' , ['deposites' => $deposites]);
}



}
