<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\employee_Expense;
use App\Employee;
use App\Analysis;
use App\Emp_Trust;

class EmployeeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }



    // Employee
public function employee_show()
{
    $employees = Employee::get();
    return view('employee.show' , ['employees' => $employees]);
}
public function employee_create_get()
{   
    return view('employee.create');
}

public function employee_create_post(Request $request) {
    
 
    $employee = Employee::create ( [ 		
            'name' => $request ['name'],
            'status'=>$request ['status'],
            'identifier_card'=>$request ['identifier_card'],
            'stay_type'=>$request ['stay_type'],
            'nationality'=>$request ['nationality'],
            'type'=>$request ['type'],
            'email'=>$request ['email'],
            'mobile'=>$request ['mobile'],
            'address'=>$request ['address'],
            'gov'=>$request ['gov'],
            'feesh'=>$request ['feesh'],
            'm_service'=>$request ['m_service'],
            'm_status'=>$request ['m_status'],
            'qualifications'=>$request ['qualifications'],
            'prev_experiance'=>$request ['prev_experiance'],
            'lang'=>$request ['lang'],
            'hire_date'=>$request ['hire_date'],
            'contract_num'=>$request ['contract_num'],
            'contract_type'=>$request ['contract_type'],
            'job'=>$request ['job'],
            'department'=>$request ['department'],
            'salary'=>$request ['salary'],
            'hour_of_day'=>$request ['hour_of_day'],
            'day_of_month'=>$request ['day_of_month'],
            'branch_id'=>$request ['branch_id'],
            'sotial_security'=>$request ['sotial_security'],
            'start_sotial_security_date'=>$request ['start_sotial_security_date'],

            
    ] );

    $employee_id = $employee->id;

    $analysis = Analysis::create (   [ 'employee_id' => $employee_id ]);
    $emp_trust = Emp_Trust::create ( [ 'employee_id' => $employee_id ]);

    session()->flash('message', 'New Employee  Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/employee/analysis_create/$employee_id" );
}


public function ananlysis_create_get($employee_id)
{   
    return view('employee.analysis' , ['employee_id'=>$employee_id]);
}

public function trusts_create_get( $employee_id)
{   
    return view('employee.trusts' , ['employee_id'=>$employee_id]);
}



public function ananlysis_create_post(Request $request) {
    
 
    $employee_id = $request ['employee_id']; 
    
    DB::table('analysis')
        ->where('employee_id', $employee_id)
        ->update([
            'last_medical_check'=>$request ['last_medical_check'],
            'next_medical_check'=>$request ['next_medical_check'],
            'last_blod'=>$request ['last_blod'],
            'next_blod'=>$request ['next_blod'],
            'last_bool'=>$request ['last_bool'],
            'next_bool'=>$request ['next_bool'],
            'last_drugs'=>$request ['last_drugs'],
            'next_drugs'=>$request ['next_drugs'],
            'last_xray'=>$request ['last_xray'],
            'next_xray'=>$request ['next_xray'],
            'notes'=>$request ['notes'],
            'updated_at' => Carbon::now() ]);

    

    session()->flash('message', 'New Analysis Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "employee/trusts_create/$employee_id" );
}



public function trusts_create_post(Request $request) {
    
    $employee_id = $request ['employee_id']; 
    
    DB::table('emp_trusts')
        ->where('employee_id', $employee_id)
        ->update([
            'tshirt'=>$request ['tshirt'],
            'jacket'=>$request ['jacket'],
            'safety'=>$request ['safety'],
            'vest'=>$request ['vest'],
            'glassess'=>$request ['glassess'],
            'cap'=>$request ['cap'],
            'helmet'=>$request ['helmet'],
            'mask'=>$request ['mask'],
            'sefty_belt'=>$request ['sefty_belt'],
            'car_belt'=>$request ['car_belt'],
            'mech_keys'=>$request ['mech_keys'],
            'mobile'=>$request ['mobile'],
            'mobile_card'=>$request ['mobile_card'],
            'pc'=>$request ['pc'],
            'lab'=>$request ['lab'],
            'software'=>$request ['software'],
            'door_keys'=>$request ['door_keys'],
            'notes'=>$request ['notes'],
            'updated_at' => Carbon::now() ]);
            
    session()->flash('message', 'New Employee  Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/employee/index" );
}

public function employee_edit_get($employee_id){
    $employee = DB::table('employee')->where('id', '=',$employee_id)->first();
    return view('employee.edit',['employee' => $employee]);
}
public function edit_analysis_get($employee_id){
    $analysis = DB::table('analysis')->where('employee_id', '=',$employee_id)->first();
    return view('employee.edit_analysis',['analysis' => $analysis]);
}
public function edit_trusts_get($employee_id){
    $trust = DB::table('emp_trusts')->where('employee_id', '=',$employee_id)->first();
    return view('employee.edit_trusts',['trust' => $trust]);
}

public function employee_edit_post(Request $request){

    $employee_id = $request ['employee_id']; 
    
    DB::table('employee')
        ->where('id', $employee_id)
        ->update([
            'name' => $request ['name'],
            'status'=>$request ['status'],
            'identifier_card'=>$request ['identifier_card'],
            'stay_type'=>$request ['stay_type'],
            'nationality'=>$request ['nationality'],
            'type'=>$request ['type'],
            'email'=>$request ['email'],
            'mobile'=>$request ['mobile'],
            'address'=>$request ['address'],
            'gov'=>$request ['gov'],
            'feesh'=>$request ['feesh'],
            'm_service'=>$request ['m_service'],
            'm_status'=>$request ['m_status'],
            'qualifications'=>$request ['qualifications'],
            'prev_experiance'=>$request ['prev_experiance'],
            'lang'=>$request ['lang'],
            'hire_date'=>$request ['hire_date'],
            'contract_num'=>$request ['contract_num'],
            'contract_type'=>$request ['contract_type'],
            'job'=>$request ['job'],
            'department'=>$request ['department'],
            'salary'=>$request ['salary'],
            'hour_of_day'=>$request ['hour_of_day'],
            'day_of_month'=>$request ['day_of_month'],
            'branch_id'=>$request ['branch_id'],
            'sotial_security'=>$request ['sotial_security'],
            'start_sotial_security_date'=>$request ['start_sotial_security_date'],
            'updated_at' => Carbon::now() ]);

    session()->flash('message', 'Employee Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/employee/edit/$employee_id" );
}


public function edit_analysis_post(Request $request){

    $employee_id = $request ['employee_id']; 
    
    DB::table('analysis')
        ->where('employee_id', $employee_id)
        ->update([
            'last_medical_check'=>$request ['last_medical_check'],
            'next_medical_check'=>$request ['next_medical_check'],
            'last_blod'=>$request ['last_blod'],
            'next_blod'=>$request ['next_blod'],
            'last_bool'=>$request ['last_bool'],
            'next_bool'=>$request ['next_bool'],
            'last_drugs'=>$request ['last_drugs'],
            'next_drugs'=>$request ['next_drugs'],
            'last_xray'=>$request ['last_xray'],
            'next_xray'=>$request ['next_xray'],
            'notes'=>$request ['notes'],
            'updated_at' => Carbon::now() ]);

    session()->flash('message', 'Employee Analysis updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/employee/edit_analysis/$employee_id" );
}



public function edit_trusts_post(Request $request){

    $employee_id = $request ['employee_id']; 
    
    DB::table('emp_trusts')
        ->where('employee_id', $employee_id)
        ->update([
            'tshirt'=>$request ['tshirt'],
            'jacket'=>$request ['jacket'],
            'safety'=>$request ['safety'],
            'vest'=>$request ['vest'],
            'glassess'=>$request ['glassess'],
            'cap'=>$request ['cap'],
            'helmet'=>$request ['helmet'],
            'mask'=>$request ['mask'],
            'sefty_belt'=>$request ['sefty_belt'],
            'car_belt'=>$request ['car_belt'],
            'mech_keys'=>$request ['mech_keys'],
            'mobile'=>$request ['mobile'],
            'mobile_card'=>$request ['mobile_card'],
            'pc'=>$request ['pc'],
            'lab'=>$request ['lab'],
            'software'=>$request ['software'],
            'door_keys'=>$request ['door_keys'],
            'notes'=>$request ['notes'],
            'updated_at' => Carbon::now() ]);

    session()->flash('message', 'Employee Trusts updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/employee/edit_trusts/$employee_id" );
}



public function employee_delete($employee_id){
    
    $Employee = Employee::find($employee_id);
    $Employee->delete();
    return redirect ( "/employee/index");
}


public function details($employee_id){
    
    $employee = DB::table('employee')->where('id', '=',$employee_id)->first();
    $trust = DB::table('emp_trusts')->where('employee_id', '=',$employee_id)->first();
    $analysis = DB::table('analysis')->where('employee_id', '=',$employee_id)->first();
    return view('employee.details',['trust' => $trust , 'employee'=>$employee , 'analysis'=>$analysis ]);

     
}

public function image($employee_id){
    
    return view('employee.image',['employee_id' => $employee_id ]);

     
}


public function image_crete(Request $request ){
    
    $employee_id = $request ['employee_id'];
    if($request->hasFile('image')){
        $image_name = $employee_id . '.PNG' ;
        $request->file ( 'image' )->move ( public_path () . '/theme/dist/img', $image_name );
       
    }
    
    return redirect ( "/employee/index");

     
}


 


     


}
