<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Client;
use App\Invoice;
use App\Invoice_Item;
use App\Invoice_Payment;
use App\Cheque;
use App\Bank;
use App\Client_Sheet;
use App\Receipt;

class BackendController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    
//////////////////////////////////////////////////
// Invoice
public function get_invoices()
{
    $branches = Branch::get();
    $invoices = Invoice::with('client', 'items' ,'payments')->where("confirmed","confirmed")->orderBy('id', 'DESC')->limit(20)->get();
    $invoices2 = [];
    foreach ($invoices as $key => $invoice) {
       foreach ($invoice["items"] as $key => $item) {
         $sell_store = Store_Branch::with('store', 'branch' )->where('id',$item->sell_store_id)->first();
         $item["sell_store"] = $sell_store;  
        }
    }

    return \Response::json(['invoices' => $invoices , 'branches'=>$branches]);

}

public function get_sell_stores_of_branch($branch_id)
{
    
    $sell_stors = Store_Branch::with('branch', 'store' )->where("branch_id",$branch_id)->get();
    

    return \Response::json(['sell_stors' => $sell_stors ]);

}

public function get_safe_accounts_of_branch($branch_id)
{
    
    $safe_accounts = Safe_Account::with('branch', 'payment_method' )->where("branch_id",$branch_id)->get();
    

    return \Response::json(['safe_accounts' => $safe_accounts ]);

}



public function get_sell_stores(){
    $branch_id =4 ;
    $sell_stores = Store_Branch::with('store')->where('branch_id',$branch_id)->get();
    return \Response::json(['sell_stores' => $sell_stores ]);
}


 



}
