<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client_Sheet extends Model
{
    public $timestamps = true;
    protected $table = 'client_sheet';
    protected $fillable = [
       'leeh','aleeh','invoice_id','client_id','receipt_id','refused_cheque'
    ];

    public function invoice()
    {
        return $this->belongsTo('App\Invoice', 'invoice_id');
    }

    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }
}

