<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Actions;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        if ( Auth::user()->is_supplier ) {
        $login_supplier_id= Auth::user()->supplier->id;
        }
        else {
            $login_supplier_id = NULL;
        }

        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->whereDate( 'created_at',"=",  Carbon::now()->format('Y-m-d') )->where('supplier_id', '=',$login_supplier_id )->where('updated_at','!=',NULL)->get();
        
        
        
        
         
         $action = "Home Page Suppliers " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Home Page Suppliers "
            ] );
            
            
         
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
    }
    
    
    
    
        public function previous_waste (Request $request)
    {
        if ( Auth::user()->is_supplier ) {
            $login_supplier_id= Auth::user()->supplier->id;
            }
            else {
                $login_supplier_id = NULL;
            }
            
        $from =  $request ['from'];
        $to =  $request ['to'];
        
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')
        ->whereDate( 'created_at',">=",  $from )
        ->whereDate( 'created_at',"<=",  $to )
        ->where('supplier_id', '=',$login_supplier_id )
        ->where('updated_at','!=',NULL)->get();


 $action = "Previous Waste Suppliers " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Previous Waste Suppliers From $from ==> to $to "
            ] );
            
            
            
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
       
    }
    
}
