<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth;
use App\Actions;

class GroupReportController  extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        return view('groupreport.create');
        
    }


  

        // ajax
        public function get_groups( $from , $to){

            $supplier_id= Auth::user()->supplier->id;
            $mains = Main::with("waste")
                                    ->whereDate('created_at','>=',$from)
                                        ->whereDate('created_at','<=',$to)
                                        //->where('customer_id' , '!=' , NULL) 
                                        ->where("supplier_id" , "=" , $supplier_id)                           
                                        ->groupBy('waste_id')
                                        ->get();
            $group_ids = [];
            foreach ( $mains as $main ) {
                $group_ids[] = $main->waste->groups_id;
            }
    
            $groups = Group::whereIn('id', $group_ids)->groupBy('name')->get();
            
            return \Response::json(['groups_' => $groups, ]);
    
        }

    // ajax
    public function get_suppliers($arr_of_groups, $from , $to){
        
        $arr = explode(',', $arr_of_groups); // convert string to array
        /*$mains = Main::with("supplier")->whereIn('waste_id', $arr)
                                    ->whereBetween( 'created_at', [$from, $to] )
                                    ->groupBy('supplier_id')
                                    ->get();
*/

        $mains = Main::with("waste", "supplier") 
                                         ->whereDate('created_at','>=',$from)
                                        ->whereDate('created_at','<=',$to)
                                        //->where('customer_id' , '!=' , NULL)
                                        ->groupBy('waste_id')
                                        ->get();
    
        
        $supplier_ids = [];
        foreach ( $mains as $main ) {
            // check if waste->groups_id exist at the selected group ids 
            if (in_array( $main->waste->groups_id , $arr)){ 
                $supplier_ids[] = $main->supplier_id;  
            }
        }   

        $suppliers = Supplier::whereIn('id', $supplier_ids)->groupBy('id')->get();

        return \Response::json(['suppliers_' => $suppliers, ]);

    }

    

    




    public function group_report_create_post(Request $request) {
    
        
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $supplier_id= Auth::user()->supplier->id;
        $selected_groups = $request ['groups']; 
         

       
        $mains = Main::with("waste", "supplier")
        ->where('supplier_id',"=",$supplier_id)
        //->where('customer_id' , '!=' , NULL)
         ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->orderBy('created_at', 'asc')
        ->get();

        $final_mains = []; // rows not ids 
        $sum_kg=0;  // kg
        $sum_num=0;  // عدد
        $total_price=0;  // sum of total price whatever kg or num

        foreach ( $mains as $main ) {
            // check if waste->groups_id exist at the selected group ids 
            if (in_array( $main->waste->groups_id , $selected_groups)){ 
                $final_mains[] = $main;

                
                if( $main->waste->unit == 'كجم' ){
                    $sum_kg = $sum_kg + $main->quantity;
                }else{
                    $sum_num = $sum_num + $main->quantity;
                }
                if ( $main->price) {
                    $price_ = $main->price * $main->quantity ; // multibly the quantity in price per unit 
                    $total_price = $total_price + $price_  ;
                }
            }
        }  


        
          ///////////////// action /////////////////
        
        $str_json_groups = json_encode($selected_groups);

       $subject = "Suppliers Group  From : ".$dateFrom ."  to : ".$dateTo." selected_groups  ids  list  ".$str_json_groups;
        $action = "Group Suppliers"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
         

        return view('groupreport.show', [
            'mains'=>$final_mains,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo,
            'sum_kg'=>$sum_kg,
            'sum_num'=>$sum_num,
            'total_price'=>$total_price
        ]);
        
    }

    




}
