<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth;
use App\Actions;
class ClassReportController  extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        return view('classreport.create');
        
    }


  

        // ajax
        public function get_wastes( $from , $to){
            $supplier_id= Auth::user()->supplier->id;
            $mains = Main::with("waste") ->whereDate('created_at','>=',$from)
                                        ->whereDate('created_at','<=',$to)
                                        //->where('customer_id' , '!=' , NULL)
                                        ->where("supplier_id" , "=" , $supplier_id)
                                        ->groupBy('waste_id')
                                        ->get();
        
            
            return \Response::json(['wastes_' => $mains, ]);
    
        }

    // ajax
    public function get_suppliers($arr_of_wastes, $from , $to){
        
        $arr = explode(',', $arr_of_wastes); // convert string to array
        $mains = Main::with("supplier")->whereIn('waste_id', $arr)
                                    ->whereDate('created_at','>=',$from)
                                        ->whereDate('created_at','<=',$to)
                                    ->groupBy('supplier_id')
                                    ->get();
    
        
        return \Response::json(['suppliers_' => $mains, ]);

    }

    

    




    public function class_report_create_post(Request $request) {
    
        
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $supplier_id= Auth::user()->supplier->id; 
        $selected_wastes = $request ['class_wastes']; 
         

       
        $mains = Main::with("waste", "supplier")
        ->where('supplier_id',"=",$supplier_id)
        ->whereIn('waste_id', $selected_wastes)
        //->where('customer_id' , '!=' , NULL)
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->orderBy('created_at', 'asc')
        ->get();

        $sum_kg=0;  // kg
        $sum_num=0;  // عدد
        $total_price=0;  // sum of total price whatever kg or num
        foreach ($mains as $main) {
           

            if( $main->waste->unit == 'كجم' ){
                $sum_kg = $sum_kg + $main->quantity;
            }else{
                $sum_num = $sum_num + $main->quantity;
            }
            if ( $main->price) {
                $price_ = $main->price * $main->quantity ; // multibly the quantity in price per unit 
                $total_price = $total_price + $price_  ;
            }
        }
         
         
         ///////////////// action /////////////////
        
        $str_json_wastes = json_encode($selected_wastes);

       $subject = "Suppliers Class  From : ".$dateFrom ."  to : ".$dateTo." selected_wastes  ids  list  ".$str_json_wastes;
        $action = "Class Suppliers"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
        

        return view('classreport.show', [
            'mains'=>$mains,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo,
            'sum_kg'=>$sum_kg,
            'sum_num'=>$sum_num,
            'total_price'=>$total_price
        ]);
        
    }

    




}
