<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth;
use App\Actions;

class ChartReportController  extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        return view('chartreport.create');
        
    }


      // ajax
      public function get_suppliers( $from , $to){
        
     
        $mains = Main::with("waste", "supplier")
        
        ->whereDate('created_at','>=',$from)
        ->whereDate('created_at','<=',$to)
        //->where('customer_id' , '!=' , NULL)
        ->groupBy('supplier_id')
        ->get();
    
        
        return \Response::json(['suppliers_' => $mains, ]);

    }

    // ajax
    public function get_classes(  $from , $to){

        $supplier_id= Auth::user()->supplier->id;
        $mains = Main::with("waste")
        ->whereDate('created_at','>=',$from)
        ->whereDate('created_at','<=',$to)
        //->where('customer_id' , '!=' , NULL) 
        ->where('supplier_id' , $supplier_id)                            
        ->groupBy('waste_id')
        ->get();

        $class_ids = [];
        foreach ( $mains as $main ) {
        $class_ids[] = $main->waste->class_id;
        }

        $classes_ = Class_::whereIn('id', $class_ids)->groupBy('name')->get(); // get all classes where belongs to the wastes of suppliers but no dublicates 

        return \Response::json(['classes_' => $classes_, ]);

    }



  // ajax 
     public function get_groups( $class_id , $from , $to ){

        $supplier_id= Auth::user()->supplier->id;
        $mains = Main::where('supplier_id',$supplier_id)
        //->where('customer_id','!=',NULL)
        ->whereDate('created_at','>=',$from)
        ->whereDate('created_at','<=',$to)
        ->get();

        $group_ids = [];
        foreach ( $mains as $main ) {
            if ( $main->waste->class_id == $class_id) { 
            $group_ids[] = $main->waste->groups_id;  // // get all groups where belongs to the wastes of suppliers and with class_id that selected but no dublicates
            }
        }

        $groups = Group::whereIn('id', $group_ids)->groupBy('name')->get();

        return \Response::json(['groups_' => $groups ]);	

    }

    

    
  // ajax 
  public function get_classifications(  $class_id , $group_id, $from ,$to  ){
        
    $supplier_id= Auth::user()->supplier->id;
    $mains = Main::where('supplier_id',$supplier_id)
                    //->where('customer_id','!=',NULL)
                    ->whereDate('created_at','>=',$from)
                    ->whereDate('created_at','<=',$to)
                    ->get();

    $classifications_id = [];
    foreach ( $mains as $main ) {
        if ( $main->waste->class_id == $class_id && $main->waste->groups_id == $group_id  ) { 
        $classifications_id[] = $main->waste->classifications_id;  // // get all groups where belongs to the wastes of suppliers and with class_id that selected but no dublicates
        }
    }

    $classifications = Classification::whereIn('id', $classifications_id)->groupBy('name')->get();

   

    return \Response::json(['classifications_' => $classifications  ]);	

}

    


    public function draw(  $class_id , $group_id, $classification_id , $dateFrom  , $dateTo ) {
    
         
        $supplier_id= Auth::user()->supplier->id;
        $mains = Main::with("waste", "supplier")
        ->where('supplier_id',$supplier_id)
        //->where('customer_id' , '!=' , NULL)
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->get();
        

        $waste_ids = []; // rows not ids 
       

        foreach ( $mains as $main ) {
            if ( $main->waste->class_id == $class_id && $main->waste->groups_id == $group_id &&  $main->waste->classifications_id == $classification_id   ){ 
                $waste_ids[] =  $main->waste_id ;
            }
        }  
         
        $final_mains = Main::with("waste")->where('supplier_id',$supplier_id)
        //->where('customer_id' , '!=' , NULL)
        ->whereIn('waste_id', $waste_ids)
        
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->groupBy('waste_id')
        ->selectRaw('*, sum(quantity) as sum')
        ->get();
         

        $class = DB::table('class')->where('id', '=',$class_id)->first();
        $group = DB::table('groups')->where('id', '=',$group_id)->first();
        $classification = DB::table('classifications')->where('id', '=',$classification_id)->first();
        $supplier = DB::table('suppliers')->where('id', '=',$supplier_id)->first();


 ///////////////// action /////////////////
        
 
       $subject = "Suppliers Chart  From : ".$dateFrom ."  to : ".$dateTo." class : $class->name , group : $group->name , classification: $classification->name  ";
        $action = "Chart Suppliers"  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => $subject
        ] );
        ///////////////////
        

        return \Response::json([ 'mains_' => $final_mains,
                                 'class_'=>$class,
                                 'group_'=>$group,
                                 'classification_'=>$classification,
                                 'supplier_'=>$supplier,
                                 'from'=>$dateFrom,
                                 'to'=>$dateTo
                                ]);
        
    }



}
