<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $login_supplier_id= Auth::user()->supplier->id;

        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user', 'price')->whereDate( 'created_at',"=",  Carbon::now()->format('Y-m-d') )->where('supplier_id', '=',$login_supplier_id )->where('updated_at','!=',NULL)->get();
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
    }
}
