<?php
require("MySQLDAO.php");
$config = parse_ini_file('../config/config.ini');
date_default_timezone_set('Africa/Cairo');
$returnValue = array();

if(  empty ($_GET["payment_voucher_id"])   )
{

    $returnValue["status"]="400";
    $returnValue["message"]="يوجد نقص في ادخال البيانات ";
    echo json_encode($returnValue);
    return;
}


$payment_voucher_id = htmlentities($_GET["payment_voucher_id"]);

$dbhost = trim($config["dbhost"]);
$dbuser = trim($config["dbuser"]);
$dbpassword = trim($config["dbpassword"]);
$dbname = trim($config["dbname"]);

$dao = new MySQLDAO($dbhost, $dbuser, $dbpassword, $dbname);
$dao->openConnection();



date_default_timezone_set('Africa/Cairo');


// $supplier_id, $waste_id , $packmethod_id , $physical_id , $vehicle_id , $driver_id  , $user_id , $branch_id , $quantity , $carta_price , $carta_tax , $created_at 


$payment_voucher_details = $dao->getPaymentVoucherDetails( $payment_voucher_id ) ;
$safe_account_id = $payment_voucher_details["safe_account_id"];
$pay = $payment_voucher_details["pay"];
$safe_account = $dao->getSafeAccountDetails( $safe_account_id ) ;    

if($pay > $safe_account["balance"]){

$returnValue["status"]="403";
$returnValue["message"]="not enough money";
$dao->closeConnection();
echo json_encode($returnValue);
return ;
}


$approved= $dao->PaymentVoucherApprove ( $payment_voucher_id);
// 1- decrease safe account
$decrease_safe_account = $dao->decreaseSafeAccount( $safe_account_id , $pay ) ;


$history_descreption = "Payment Voucher num $payment_voucher_id  Decrease Safe Account num $safe_account_id by $pay";
$history_payment_voucher_id = $payment_voucher_id;
$history_safe_account_id = $safe_account_id;
$balance_before =  $safe_account["balance"];
$balance_after = $safe_account["balance"] - $pay;

// 2- add history 
$safe_history = $dao->addHistoryRecord( $balance_before , $balance_after , $history_payment_voucher_id, $history_safe_account_id , $history_descreption ) ;


  if ( $approved){
    $returnValue["status"]="200";
    $returnValue["message"]=" تم قبول السند بنجاح ";
    $dao->closeConnection();
    echo json_encode($returnValue);
  } else { 

    $returnValue["status"]="403";
    $returnValue["message"]="لم يتم قبول العهدة ";
    $dao->closeConnection();
    echo json_encode($returnValue);
  }
?> 