<?php
require("MySQLDAO.php");
$config = parse_ini_file('../config/config.ini');
date_default_timezone_set('Africa/Cairo');
$returnValue = array();

if(  empty ($_GET["waste_id"])  || empty($_GET["packmethod_id"]) 
        || empty($_GET["physical_id"]) || empty($_GET["vehicle_id"]) 
        || empty($_GET["driver_id"]) || empty($_GET["quantity"])
        || empty($_GET["supplier_id"]) || empty($_GET["user_id"]) || empty($_GET["branch_id"])   )
{

    $returnValue["status"]="400";
    $returnValue["message"]="يوجد نقص في ادخال البيانات ";
    echo json_encode($returnValue);
    return;
}


$waste_id = htmlentities($_GET["waste_id"]);
$packmethod_id = htmlentities($_GET["packmethod_id"]);
$physical_id    = htmlentities($_GET["physical_id"]);
$vehicle_id = htmlentities($_GET['vehicle_id']);
$driver_id = htmlentities($_GET["driver_id"]);
$quantity = htmlentities($_GET['quantity']);
$supplier_id  = htmlentities($_GET['supplier_id']);
$user_id  = htmlentities($_GET['user_id']);
$branch_id = htmlentities($_GET['branch_id']);

$dbhost = trim($config["dbhost"]);
$dbuser = trim($config["dbuser"]);
$dbpassword = trim($config["dbpassword"]);
$dbname = trim($config["dbname"]);

$dao = new MySQLDAO($dbhost, $dbuser, $dbpassword, $dbname);
$dao->openConnection();


// mobil app depend on the price of the current date , today price , today date 
// if the borsa from admin app not set , it should be null 

$waste_row = $dao->getWasteById($waste_id);
$waste_row_price = $waste_row["price"];
$waste_row_tax = $waste_row["tax"];
$carta_price = NULL;
$carta_tax = NULL ;

if ( $waste_row_price != NULL && $waste_row_price >= 0 ) { // valid price 
    $carta_price=  $waste_row_price ;
}
if ( $waste_row_tax != NULL && $waste_row_tax >= 0 ) { // valid price 
    $carta_tax = $waste_row_tax;
}


date_default_timezone_set('Africa/Cairo');
$created_at = date('Y-m-d H:i:s');
$date = date('Y-m-d');

// $supplier_id, $waste_id , $packmethod_id , $physical_id , $vehicle_id , $driver_id  , $user_id , $branch_id , $quantity , $carta_price , $carta_tax , $created_at 

$added = $dao->addNewWaste( $supplier_id, $waste_id , $packmethod_id , $physical_id , $vehicle_id , $driver_id  , $user_id , $branch_id , $quantity , $carta_price , $carta_tax , $created_at , $date ) ;

//added == main_id inserted 
// get store
$store_id = $waste_row["store_id"];
if ( $store_id ){
    // get sell store 
    $sell_store = $dao->getSellStoreById($store_id ,$branch_id );
    if ( $sell_store ){
    $sell_store_id = $sell_store["id"];
    $dao->updateMain_add_sell_store_id($added,$sell_store_id);
    $dao->update_sell_store($sell_store_id,$quantity);
    $desc="Mob Add new Carta increase sell_store by ".$quantity;
    $quantity_before=$sell_store["quantity"]; 
    $quantity_after=$sell_store["quantity"] + $quantity;
    $his = $dao->add_sel_store_history($quantity_before,$quantity_after , $added, $user_id, $sell_store_id , $desc   );
    }
    
}


  if ( $added){
    $returnValue["status"]="200";
    $returnValue["message"]=" تم أضافة الكارتة بنجاح و شكرا لك  ";
    $dao->closeConnection();
    echo json_encode($returnValue);
  } else { 

    $returnValue["status"]="403";
    $returnValue["message"]="لم يتم الاضافة بنجاح راجع المعلومات ";
    $dao->closeConnection();
    echo json_encode($returnValue);
  }
?> 